/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.util.ValueUtil;

public class ModelPartConfig {
    public boolean notShared = false;
    public final float[] scale = new float[]{1.0f, 1.0f, 1.0f};
    public final float[] offset = new float[]{0.0f, 0.0f, 0.0f};

    public void copyValues(ModelPartConfig config) {
        for (int i = 0; i < 3; ++i) {
            this.scale[i] = config.scale[i];
            this.offset[i] = config.offset[i];
        }
    }

    public void load(NBTTagCompound compound) {
        this.scale[0] = ValueUtil.correctFloat(compound.func_74760_g("ScaleX"), 0.5f, 1.5f);
        this.scale[1] = ValueUtil.correctFloat(compound.func_74760_g("ScaleY"), 0.5f, 1.5f);
        this.scale[2] = ValueUtil.correctFloat(compound.func_74760_g("ScaleZ"), 0.5f, 1.5f);
        this.offset[0] = ValueUtil.correctFloat(compound.func_74760_g("TransX"), -1.0f, 1.0f);
        this.offset[1] = ValueUtil.correctFloat(compound.func_74760_g("TransY"), -1.0f, 1.0f);
        this.offset[2] = ValueUtil.correctFloat(compound.func_74760_g("TransZ"), -1.0f, 1.0f);
        this.notShared = compound.func_74767_n("NotShared");
    }

    public void setScale(float x, float y) {
        this.scale[0] = ValueUtil.correctFloat(x, 0.5f, 1.5f);
        this.scale[1] = ValueUtil.correctFloat(x, 0.5f, 1.5f);
        this.scale[2] = ValueUtil.correctFloat(y, 0.5f, 1.5f);
    }

    public void setScale(float x, float y, float z) {
        this.scale[0] = ValueUtil.correctFloat(x, 0.5f, 1.5f);
        this.scale[1] = ValueUtil.correctFloat(y, 0.5f, 1.5f);
        this.scale[2] = ValueUtil.correctFloat(z, 0.5f, 1.5f);
    }

    public void setTranslate(float transX, float transY, float transZ) {
        this.offset[0] = ValueUtil.correctFloat(transX, -1.0f, 1.0f);
        this.offset[1] = ValueUtil.correctFloat(transY, -1.0f, 1.0f);
        this.offset[2] = ValueUtil.correctFloat(transZ, -1.0f, 1.0f);
    }

    public NBTTagCompound save() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74776_a("ScaleX", this.scale[0]);
        compound.func_74776_a("ScaleY", this.scale[1]);
        compound.func_74776_a("ScaleZ", this.scale[2]);
        compound.func_74776_a("TransX", this.offset[0]);
        compound.func_74776_a("TransY", this.offset[1]);
        compound.func_74776_a("TransZ", this.offset[2]);
        compound.func_74757_a("NotShared", this.notShared);
        return compound;
    }
}

